#!/system/bin/sh

set -e

if dd if=/dev/block/bootdevice/by-name/factory skip=31744 bs=1024 |decode-persist-ram > /data/logs/last_kmsg.$$; then
    echo extracted | dd of=/dev/block/bootdevice/by-name/factory bs=1024 seek=31744

    if ! grep -q "Kernel panic" /data/logs/last_kmsg.$$; then
        echo "[43387.701472] Kernel panic - not syncing: added by bhj, should check the ramdump" >> /data/logs/last_kmsg.$$
    fi
    if test -e /data/logs/last_kmsg && diff -q /data/logs/last_kmsg.$$ /data/logs/last_kmsg; then
        touch /data/logs/last_kmsg.outdated
    else
        log -t Scitd "Found last kmsg, copy it to /dev/rem-last_kmsg"
        cp /data/logs/last_kmsg.$$ /dev/rem-last_kmsg # this directory is tmpfs
        rm /data/logs/last_kmsg.outdated || true
    fi

    if test -e /data/logs/last_kmsg && ! diff -q /data/logs/last_kmsg.$$ /data/logs/last_kmsg; then
        for x in $(seq 4 -1 1); do
            mv /data/logs/last_kmsg.bak.$x /data/logs/last_kmsg.bak.$((x+1)) || true
        done
        mv /data/logs/last_kmsg /data/logs/last_kmsg.bak.1
    fi
    mv /data/logs/last_kmsg.$$ /data/logs/last_kmsg
    cp /data/logs/last_kmsg log-last_kmsg
else
    rm -f /data/logs/last_kmsg.$$
fi

exit 0
