#!/usr/bin/awk

BEGIN {
    types["MemTotal"] = 1;
    types["Pss"] = 1;
    types["MemFree"] = 1;
    types["Cached"] = 1;
    types["Buffers"] = 1;
    types["Shmem"] = 1;
    types["Slab"] = 1;
}


## start code-generator "^\\s *#"
#echo
# for x in Pss MemTotal MemFree Cached Buffers Shmem Slab; do
#     cat << EOF
#/$x: / {
#     hash["$x"] += \$2;
# next
#}
#
#EOF
# done
## end code-generator
## start generated code

/Pss: / {
    hash["Pss"] += $2;
    next
 }

 /MemTotal: / {
     hash["MemTotal"] += $2;
     next
 }

 /MemFree: / {
     hash["MemFree"] += $2;
     next
 }

 /Cached: / {
     hash["Cached"] += $2;
     next
 }

 /Buffers: / {
     hash["Buffers"] += $2;
     next
 }

 /Shmem: / {
     hash["Shmem"] += $2;
     next
 }

 /Slab: / {
     hash["Slab"] += $2;
     next
 }


## end generated code

END {
    lost =  0;
    for (type in types) {
        if (type == "MemTotal") {
            lost += hash[type];
        } else {
            lost -= hash[type];
        }
    }
    print "lost: " lost " kB\n";
}
