#!/system/bin/sh

## part 1, pre-install app
cd /system/media/app

#android shell script: check if preinstall is exist
if [ -s /data/property/persist.preinstalled ]; then
    echo "don't need to copy preinstall files"
else
    # scan all apk files under system/media/app
    apklist="$(ls)"
    for apkfile in ${apklist}; do
        # copy all apk file to data/app
        cp ${apkfile} /data/app/${apkfile}
        # change the permission
        chown 1000:1000 /data/app/${apkfile}
        chmod 644 /data/app/${apkfile}
    done
    setprop persist.preinstalled  y
fi


# part 2, pre-install icon
if [ -s /data/property/persist.icon.preinstalled ]; then
    echo "don't need to copy pre-install icons"
else
    mkdir /data/system/icon
    chown 1000:1000 /data/system/icon
    chmod 775 /data/system/icon

    cd /system/media/icon
    pkglist="$(ls)"
    for pkg in ${pkglist}; do
        if [ ! -d /data/system/icon/${pkg} ]; then
            mkdir /data/system/icon/${pkg}
            chown 1000:1000 /data/system/icon/${pkg}
            chmod 775 /data/system/icon/${pkg}
            cd /system/media/icon/${pkg}
            filelist="$(ls)"
            for file in ${filelist}; do
                cp ${file} /data/system/icon/${pkg}/${file}
                chown 1000:1000 /data/system/icon/${pkg}/${file}
                chmod 644 /data/system/icon/${pkg}/${file}
            done
        fi
    done
    setprop persist.icon.preinstalled y
fi
