#!/system/bin/sh
# Copyright (c) 2009-2013, The Linux Foundation. All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#     * Redistributions of source code must retain the above copyright
#       notice, this list of conditions and the following disclaimer.
#     * Redistributions in binary form must reproduce the above copyright
#       notice, this list of conditions and the following disclaimer in the
#       documentation and/or other materials provided with the distribution.
#     * Neither the name of The Linux Foundation nor
#       the names of its contributors may be used to endorse or promote
#       products derived from this software without specific prior written
#       permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NON-INFRINGEMENT ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
# CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
# EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
# PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
# OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
# WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
# OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
# ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#

#Read the arguments passed to the script

LOG_TAG="qcom-sensor"
LOG_NAME="${0}:"

loge ()
{
  /system/bin/log -t $LOG_TAG -p e "$LOG_NAME $@"
}

logi ()
{
  /system/bin/log -t $LOG_TAG -p i "$LOG_NAME $@"
}

logi "In qcom sensor shell Script"

# sensor type such as G-sensor , P/L-sensor, GYRO-Sensor, E-compass,  etc
SENSOR_TYPE="${1}"

#  sensor calibration
#  sensor driver node ops
#

case $SENSOR_TYPE in
  1) if [ -e /sys/class/sensors/MPU6050-accel ];then
        cat /sys/class/sensors/MPU6050-accel/self_test
    else
        cat /sys/class/sensors/bmi160-accel/self_test
    fi
     logi "SENSOR_TYPE: ACCEL-sensor";;
  2) cd /;
     logi "Sensor Type: MAG-Sensor";;
  3) if [ -e /sys/class/sensors/MPU6050-gyro ];then
        cat /sys/class/sensors/MPU6050-gyro/self_test
    else
        cat /sys/class/sensors/bmi160-gyro/self_test
    fi
     logi "Sensor Type: GYRO-Sensor";;
  4) cd /;
     logi "Sensor Type: LIGHT-Sensor";;
  5) cd /;
     logi "Sensor Type: PRESSURE-Sensor";;
  6) cd /;
    if [ -e /sys/bus/i2c/devices/0-0068/acc_offset_x ];then
        cat /sys/bus/i2c/devices/0-0068/acc_offset_x
    else
        cat /sys/class/input/input0/offset_x
    fi;;
  7) cd /;
    if [ -e /sys/bus/i2c/devices/0-0068/acc_offset_y ];then
        cat /sys/bus/i2c/devices/0-0068/acc_offset_y
    else
        cat /sys/class/input/input0/offset_y
    fi;;
  8) cd /;
    if [ -e /sys/bus/i2c/devices/0-0068/acc_offset_z ];then
        cat /sys/bus/i2c/devices/0-0068/acc_offset_z
    else
        cat /sys/class/input/input0/offset_z
    fi;;
  *) cd /;
     logi "Sensor Type: Other sensors ";;

esac

exit 0
